/* SPDX-License-Identifier: GPL-2.0-only OR MIT */

#ifndef __SOC_MEDIATEK_MT8189_INCLUDE_SOC_MCUPM_PLAT_H__
#define __SOC_MEDIATEK_MT8189_INCLUDE_SOC_MCUPM_PLAT_H__

#include <soc/addressmap.h>

#define MCUPM_SW_RSTN	MCUPM_CFG_BASE

/*
 * SPM config:
 * Enable register access key, POWERON_CONFIG_EN = 0x0B160001
 */
#define DEVAPC_INFRA_SECU_AO_SEC_REPLACE_0	(DEVAPC_INFRA_SECU_AO_BASE + 0x0300)
#define POLLING_ACK_RETRY_COUNTS	10
#define POLLING_SRAM_RETRY_COUNTS	10

/* CPUEB_PWR_CON (0x1C001000+0xEB4) */
#define CPUEB_PWR_RST_B_LSB			BIT(0)
#define CPUEB_PWR_ISO_LSB			BIT(1)
#define CPUEB_PWR_ON_LSB			BIT(2)
#define CPUEB_PWR_ON_2ND_LSB			BIT(3)
#define CPUEB_PWR_CLK_DIS_LSB			BIT(4)
#define CPUEB_SRAM_CKISO_LSB			BIT(5)
#define CPUEB_SRAM_ISOINT_B_LSB			BIT(6)
#define CPUEB_SRAM_PDN_LSB			BIT(8)
#define CPUEB_SRAM_SLEEP_B_LSB			BIT(9)
#define SC_CPUEB_SRAM_PDN_ACK_LSB		BIT(12)
#define SC_CPUEB_SRAM_SLEEP_B_ACK_LSB		BIT(13)
#define SC_CPUEB_PWR_ACK_LSB			BIT(30)
#define SC_CPUEB_PWR_ACK_2ND_LSB		BIT(31)

#define MCUPM_SRAM_SIZE		0x30000 /* 192K Bytes */

#define MCUPM_LOADER_SIZE	0x2300 /* CFG_MTCMOS_OFF_SUPPORT */
#define MCUPM_TCM_SZ		0x30000 /* 192K */
#define MCUPM_IMG_OFS		0x2300 /* CFG_MTCMOS_OFF_SUPPORT */
#define MCUPM_RDMP_OFS		0x30000

#define ABNORMALBOOT_REG_STATUS			0x0
#define WARMBOOT_REG_STATUS			0x0
#define MCUPM_RSTN_RESET			0x1F
#define MCUPM_RSTN_RSTN_INIT			0x0
#define MCUPM_CFGREG_SW_RSTN_SW_RSTN		BIT(0)
#define MCUPM_CFGREG_SW_RSTN_DMA_BUSY_MASK	BIT(1)

#define MCUPM_GPR_SIZE		0x64
#define SRAM_GPR_SIZE		0x4 /* 4 Bytes */
#define IPI_NUMBER		8
#define IPI_MBOX_TOTAL		IPI_NUMBER
#define MBOX_SLOT_SIZE		0x4
#define SRAM_SLOT_NUM		0x14 /* 0x14 = 20 slots = 20*4Bytes = 80 Bytes */
#define PIN_S_NUM		SRAM_SLOT_NUM
#define PIN_R_NUM		SRAM_SLOT_NUM
#define MBOX_TABLE_NUM		(PIN_S_NUM + PIN_R_NUM)

#define GPR_BASE_ADDR_MCU(x)	(MCUPM_SRAM_BASE + \
				 MCUPM_SRAM_SIZE - \
				 (IPI_MBOX_TOTAL * MBOX_TABLE_NUM * MBOX_SLOT_SIZE) - \
				 MCUPM_GPR_SIZE + \
				 ((x) * SRAM_GPR_SIZE))

#define MCUPM_INFO				GPR_BASE_ADDR_MCU(0)
#define ABNORMALBOOT_REG			GPR_BASE_ADDR_MCU(1)
#define WARMBOOT_REG				GPR_BASE_ADDR_MCU(23)

#endif
