"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BitMask = void 0;
var BitMask;
(function (BitMask) {
    function Falses(n) {
        const mask = [];
        for (let id = 0; id < n; id++) {
            mask[id] = false;
        }
        return mask;
    }
    BitMask.Falses = Falses;
    function Trues(n) {
        const mask = [];
        for (let id = 0; id < n; id++) {
            mask[id] = true;
        }
        return mask;
    }
    BitMask.Trues = Trues;
    function allFalseN(n, mask) {
        for (let id = 0; id < n; id++) {
            if (mask[id])
                return false;
        }
        return true;
    }
    BitMask.allFalseN = allFalseN;
    function allTrueN(n, mask) {
        for (let id = 0; id < n; id++) {
            if (!mask[id])
                return false;
        }
        return true;
    }
    BitMask.allTrueN = allTrueN;
    function allFalse(mask) {
        return allFalseN(mask.length, mask);
    }
    BitMask.allFalse = allFalse;
    function allTrue(mask) {
        return allTrueN(mask.length, mask);
    }
    BitMask.allTrue = allTrue;
    function toIndexes(mask) {
        const a = [];
        for (let id = 0; id < mask.length; id++) {
            if (mask[id])
                a.push(id);
        }
        return a;
    }
    BitMask.toIndexes = toIndexes;
})(BitMask || (exports.BitMask = BitMask = {}));
//# sourceMappingURL=index.js.map