"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeadExtendStat = void 0;
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
class HeadExtendStat {
    constructor(head, outer) {
        this.head = head;
        this.outer = outer;
        this.fontBBox = new ot_glyphs_1.OtGlyph.Stat.BoundingBoxBuilder();
    }
    setNumGlyphs(count) {
        if (this.outer)
            this.outer.setNumGlyphs(count);
    }
    setMetric(gid, horizontal, vertical, extent) {
        if (this.outer)
            this.outer.setMetric(gid, horizontal, vertical, extent);
    }
    simpleGlyphStat(st) {
        this.fontBBox.addBox(st.extent);
        if (this.outer)
            this.outer.simpleGlyphStat(st);
    }
    complexGlyphStat(st) {
        this.fontBBox.addBox(st.extent);
        if (this.outer)
            this.outer.complexGlyphStat(st);
    }
    instructionsStat(size) {
        if (this.outer)
            this.outer.instructionsStat(size);
    }
    settle() {
        const bb = this.fontBBox.getResult();
        this.head.xMin = bb.xMin;
        this.head.xMax = bb.xMax;
        this.head.yMin = bb.yMin;
        this.head.yMax = bb.yMax;
        if (this.outer)
            this.outer.settle();
    }
}
exports.HeadExtendStat = HeadExtendStat;
//# sourceMappingURL=head.js.map