package csscolorparser

import "testing"

func TestBrowserChromium(t *testing.T) {
	type testData struct {
		colorStr   string
		r, g, b, a uint8
	}
	// Randomly generated color string, parsed using Chromium 87.0.4280.66
	data := []testData{
		{"#13EF", 17, 51, 238, 255},
		{"#b42f", 187, 68, 34, 255},
		{"#49e97851", 73, 233, 120, 81},
		{"#8C68B2E0", 140, 104, 178, 224},
		{"#AE42B424", 174, 66, 180, 36},
		{"#60b", 102, 0, 187, 255},
		{"#9675E6EA", 150, 117, 230, 234},
		{"#7858", 119, 136, 85, 136},
		{"#f06", 255, 0, 102, 255},
		{"#C82", 204, 136, 34, 255},
		{"#70A8AA", 112, 168, 170, 255},
		{"#198", 17, 153, 136, 255},
		{"#bc94198b", 188, 148, 25, 139},
		{"#FC3B98", 252, 59, 152, 255},
		{"#541a3847", 84, 26, 56, 71},
		{"#29A", 34, 153, 170, 255},
		{"#4FA2DC", 79, 162, 220, 255},
		{"#812", 136, 17, 34, 255},
		{"#7A57AD0C", 122, 87, 173, 12},
		{"#F74", 255, 119, 68, 255},
		{"#ADB", 170, 221, 187, 255},
		{"#774AD2B1", 119, 74, 210, 177},
		{"#ECC", 238, 204, 204, 255},
		{"#DCF724B3", 220, 247, 36, 179},
		{"#716195", 113, 97, 149, 255},
		{"#FC39", 255, 204, 51, 153},
		{"#D3B", 221, 51, 187, 255},
		{"#7795", 119, 119, 153, 85},
		{"#387B", 51, 136, 119, 187},
		{"#C3CE", 204, 51, 204, 238},
		{"#BF88D793", 191, 136, 215, 147},
		{"#D97C", 221, 153, 119, 204},
		{"#401D", 68, 0, 17, 221},
		{"#0daf68", 13, 175, 104, 255},
		{"#C84E7484", 200, 78, 116, 132},
		{"#284", 34, 136, 68, 255},
		{"#248", 34, 68, 136, 255},
		{"#3422AF", 52, 34, 175, 255},
		{"#46E", 68, 102, 238, 255},
		{"#2ec6d703", 46, 198, 215, 3},
		{"#29F659", 41, 246, 89, 255},
		{"#69355999", 105, 53, 89, 153},
		{"#4099", 68, 0, 153, 153},
		{"#44abea", 68, 171, 234, 255},
		{"#0623B60A", 6, 35, 182, 10},
		{"#4304F493", 67, 4, 244, 147},
		{"#91176A", 145, 23, 106, 255},
		{"#875994CF", 135, 89, 148, 207},
		{"#806F", 136, 0, 102, 255},
		{"#DD32", 221, 221, 51, 34},
		{"rgb(105.927,150.994,15.104)", 106, 151, 15, 255},
		{"rgb(10.837,152.535,154.317,0.568)", 11, 153, 154, 145},
		{"rgb(237.623,156.627,211.140,-0.058)", 238, 157, 211, 0},
		{"rgb(80.685,2.873,82.097,0.592)", 81, 3, 82, 151},
		{"rgb(31.530,138.330,246.696)", 32, 138, 247, 255},
		{"rgb(127.659,188.444,102.421)", 128, 188, 102, 255},
		{"rgb(114.062,6.757,101.538)", 114, 7, 102, 255},
		{"rgb(34.047,96.606,76.235,0.045)", 34, 97, 76, 11},
		{"rgb(214.707,10.143,78.461)", 215, 10, 78, 255},
		{"rgb(158.355,172.716,136.060)", 158, 173, 136, 255},
		{"rgb(41.366,221.162,32.067,1.107)", 41, 221, 32, 255},
		{"rgb(247.083,25.052,0.185)", 247, 25, 0, 255},
		{"rgb(67.440,90.228,257.506)", 67, 90, 255, 255},
		{"rgb(99.603,18.924,133.951)", 100, 19, 134, 255},
		{"rgb(71.837,242.253,112.316)", 72, 242, 112, 255},
		{"rgb(262.877,206.567,71.233)", 255, 207, 71, 255},
		{"rgb(153.467,73.396,96.642,1.070)", 153, 73, 97, 255},
		{"rgb(253.472,35.005,92.178,0.210)", 253, 35, 92, 54},
		{"rgb(63.611,20.378,1.885)", 64, 20, 2, 255},
		{"rgb(70.695,209.671,111.060)", 71, 210, 111, 255},
		{"rgb(35.748,184.365,-3.144,-0.099)", 36, 184, 0, 0},
		{"rgb(213.630,43.353,243.800,0.932)", 214, 43, 244, 238},
		{"rgb(4.895,236.929,198.497,0.162)", 5, 237, 198, 41},
		{"rgb(262.492,104.420,135.986)", 255, 104, 136, 255},
		{"rgb(196.148,82.928,2.328,1.194)", 196, 83, 2, 255},
		{"rgb(3.984,130.315,223.066)", 4, 130, 223, 255},
		{"rgb(5.098,7.075,228.457)", 5, 7, 228, 255},
		{"rgb(132.649,122.071,261.147)", 133, 122, 255, 255},
		{"rgb(215.091,198.018,80.956,0.673)", 215, 198, 81, 172},
		{"rgb(224.466,219.548,80.411)", 224, 220, 80, 255},
		{"rgb(88.093,249.677,143.753)", 88, 250, 144, 255},
		{"rgb(261.342,42.332,150.964,0.257)", 255, 42, 151, 66},
		{"rgb(24.315,19.390,143.873)", 24, 19, 144, 255},
		{"rgb(206.152,103.265,49.028)", 206, 103, 49, 255},
		{"rgb(121.903,253.961,42.196,0.698)", 122, 254, 42, 178},
		{"rgb(81.981,163.951,231.462)", 82, 164, 231, 255},
		{"rgb(-9.058,143.858,233.204)", 0, 144, 233, 255},
		{"rgb(192.509,117.856,-7.540)", 193, 118, 0, 255},
		{"rgb(25.067,206.513,164.628)", 25, 207, 165, 255},
		{"rgb(194.332,192.906,10.594,0.980)", 194, 193, 11, 250},
		{"rgb(112.924,234.651,160.614)", 113, 235, 161, 255},
		{"rgb(250.062,24.310,60.243)", 250, 24, 60, 255},
		{"rgb(103.655,61.625,36.981)", 104, 62, 37, 255},
		{"rgb(41.189,109.543,71.332)", 41, 110, 71, 255},
		{"rgb(62.731,22.426,-1.441,0.018)", 63, 22, 0, 5},
		{"rgb(260.117,262.267,234.967)", 255, 255, 235, 255},
		{"rgb(4.026,-1.738,159.101)", 4, 0, 159, 255},
		{"rgb(231.300,105.609,231.611,0.289)", 231, 106, 232, 74},
		{"rgb(92.148,125.339,3.161)", 92, 125, 3, 255},
		{"rgb(141.451,213.294,42.291)", 141, 213, 42, 255},
		{"rgb(106.637%,63.245%,13.953%)", 255, 161, 36, 255},
		{"rgb(36.891%,83.946%,-0.776%,-0.109)", 94, 214, 0, 0},
		{"rgb(30.098%,57.177%,97.202%)", 77, 146, 248, 255},
		{"rgb(20.348%,9.007%,50.198%)", 52, 23, 128, 255},
		{"rgb(65.635%,38.597%,51.540%)", 167, 98, 131, 255},
		{"rgb(82.140%,86.294%,74.226%)", 209, 220, 189, 255},
		{"rgb(68.001%,43.582%,-8.031%,0.953)", 173, 111, 0, 243},
		{"rgb(97.555%,88.344%,107.508%,1.067)", 249, 225, 255, 255},
		{"rgb(103.833%,31.883%,106.519%,1.096)", 255, 81, 255, 255},
		{"rgb(91.878%,77.833%,42.737%,1.036)", 234, 198, 109, 255},
		{"rgb(-1.946%,104.666%,92.518%)", 0, 255, 236, 255},
		{"rgb(-8.918%,43.768%,48.678%)", 0, 112, 124, 255},
		{"rgb(22.344%,108.142%,25.588%,0.568)", 57, 255, 65, 145},
		{"rgb(-4.792%,103.802%,25.728%,1.044)", 0, 255, 66, 255},
		{"rgb(9.756%,-4.527%,55.095%)", 25, 0, 140, 255},
		{"rgb(4.812%,102.908%,-9.392%)", 12, 255, 0, 255},
		{"rgb(3.693%,104.465%,84.813%)", 9, 255, 216, 255},
		{"rgb(29.187%,99.246%,53.246%)", 74, 253, 136, 255},
		{"rgb(-7.354%,95.764%,105.057%)", 0, 244, 255, 255},
		{"rgb(47.159%,48.044%,109.916%)", 120, 123, 255, 255},
		{"rgb(45.759%,42.046%,91.989%)", 117, 107, 235, 255},
		{"rgb(86.097%,91.214%,42.376%,0.086)", 220, 233, 108, 22},
		{"rgb(13.127%,1.330%,40.329%)", 33, 3, 103, 255},
		{"rgb(65.359%,88.567%,8.510%)", 167, 226, 22, 255},
		{"rgb(63.728%,14.245%,39.191%)", 163, 36, 100, 255},
		{"rgb(82.029%,70.333%,22.627%,0.130)", 209, 179, 58, 33},
		{"rgb(-7.584%,24.596%,106.456%,0.540)", 0, 63, 255, 138},
		{"rgb(34.295%,33.879%,25.945%)", 87, 86, 66, 255},
		{"rgb(36.848%,55.483%,24.020%,0.215)", 94, 141, 61, 55},
		{"rgb(34.615%,79.081%,96.135%,0.104)", 88, 202, 245, 27},
		{"rgb(29.072%,76.973%,103.559%)", 74, 196, 255, 255},
		{"rgb(-1.165%,18.030%,23.750%)", 0, 46, 61, 255},
		{"rgb(23.834%,-4.078%,35.657%)", 61, 0, 91, 255},
		{"rgb(10.751%,0.545%,73.270%)", 27, 1, 187, 255},
		{"rgb(44.688%,9.295%,-1.679%)", 114, 24, 0, 255},
		{"rgb(72.485%,65.899%,108.170%,0.917)", 185, 168, 255, 234},
		{"rgb(34.422%,77.037%,93.107%)", 88, 196, 237, 255},
		{"rgb(91.368%,55.279%,62.854%)", 233, 141, 160, 255},
		{"rgb(102.434%,56.702%,33.212%)", 255, 145, 85, 255},
		{"rgb(39.892%,87.191%,100.708%)", 102, 222, 255, 255},
		{"rgb(65.042%,105.175%,5.622%)", 166, 255, 14, 255},
		{"rgb(-5.767%,48.382%,-5.126%)", 0, 123, 0, 255},
		{"rgb(17.665%,40.385%,80.169%)", 45, 103, 204, 255},
		{"rgb(84.019%,-0.364%,9.859%,0.625)", 214, 0, 25, 159},
		{"rgb(108.993%,100.397%,52.671%)", 255, 255, 134, 255},
		{"rgb(19.223%,47.737%,51.318%)", 49, 122, 131, 255},
		{"rgb(7.603%,70.494%,61.450%)", 19, 180, 157, 255},
		{"rgb(10.202%,89.790%,78.516%)", 26, 229, 200, 255},
		{"rgb(77.686%,97.221%,100.579%,0.246)", 198, 248, 255, 63},
		{"rgb(-2.333%,11.540%,89.009%,0.802)", 0, 29, 227, 205},
		{"hsl(303.505deg,40.607%,47.237%,-0.108)", 169, 72, 164, 0},
		{"hsl(166.317grad,35.505%,61.623%,0.885)", 122, 192, 157, 226},
		{"hsl(0.890turn,84.315%,-4.192%,0.733)", 0, 0, 0, 187},
		{"hsl(4.367rad,26.559%,25.815%,1.025)", 54, 48, 83, 255},
		{"hsl(129.011deg,24.599%,10.476%)", 20, 33, 22, 255},
		{"hsl(0.132turn,18.948%,108.092%)", 255, 255, 255, 255},
		{"hsl(6.366rad,86.281%,76.850%)", 247, 153, 145, 255},
		{"hsl(0.025turn,9.070%,17.743%)", 49, 42, 41, 255},
		{"hsl(346.054grad,22.344%,71.574%,-0.062)", 199, 166, 193, 0},
		{"hsl(0.015turn,35.648%,92.027%)", 242, 229, 227, 255},
		{"hsl(47.756grad,14.468%,86.803%)", 226, 223, 216, 255},
		{"hsl(82.948deg,106.898%,51.390%,0.409)", 160, 255, 7, 104},
		{"hsl(30.836deg,-6.307%,103.528%)", 255, 255, 255, 255},
		{"hsl(43.265,70.201%,70.996%)", 233, 204, 129, 255},
		{"hsl(128.089grad,69.628%,64.418%)", 111, 227, 101, 255},
		{"hsl(32.213,84.179%,0.508%,0.967)", 2, 1, 0, 247},
		{"hsl(243.278deg,107.466%,94.419%,-0.087)", 228, 227, 255, 0},
		{"hsl(17.877,56.334%,102.965%,0.275)", 255, 255, 255, 70},
		{"hsl(290.112,107.611%,108.356%)", 255, 255, 255, 255},
		{"hsl(200.221grad,30.283%,11.069%)", 20, 37, 37, 255},
		{"hsl(0.738turn,12.560%,3.624%,0.318)", 9, 8, 10, 81},
		{"hsl(0.109turn,70.850%,74.131%,1.187)", 236, 203, 142, 255},
		{"hsl(163.566,83.141%,36.520%)", 16, 171, 128, 255},
		{"hsl(132.194,80.652%,105.081%,1.052)", 255, 255, 255, 255},
		{"hsl(307.249deg,60.237%,26.132%)", 107, 26, 97, 255},
		{"hsl(87.916grad,18.382%,-5.926%,0.725)", 0, 0, 0, 185},
		{"hsl(0.923turn,22.762%,41.884%,1.001)", 131, 82, 105, 255},
		{"hsl(316.684grad,55.930%,52.703%,0.661)", 168, 67, 202, 169},
		{"hsl(0.939turn,57.243%,97.977%,1.009)", 253, 247, 249, 255},
		{"hsl(-0.091turn,27.351%,92.166%)", 240, 230, 236, 255},
		{"hsl(1.089turn,103.459%,55.996%,0.097)", 255, 150, 31, 25},
		{"hsl(174.033deg,10.079%,29.391%)", 67, 83, 81, 255},
		{"hsl(201.674,28.476%,8.261%)", 15, 23, 27, 255},
		{"hsl(142.622deg,39.472%,90.933%,-0.126)", 223, 241, 230, 0},
		{"hsl(4.658rad,107.070%,7.771%,0.600)", 18, 0, 40, 153},
		{"hsl(4.880rad,80.889%,-9.699%,0.319)", 0, 0, 0, 81},
		{"hsl(1.121rad,-5.569%,97.761%,1.084)", 249, 249, 249, 255},
		{"hsl(262.036,5.324%,-4.960%,0.148)", 0, 0, 0, 38},
		{"hsl(-0.455grad,41.379%,78.928%)", 224, 179, 179, 255},
		{"hsl(0.390turn,105.835%,79.907%)", 153, 255, 187, 255},
		{"hsl(0.347turn,-9.555%,33.512%)", 85, 85, 85, 255},
		{"hsl(5.535rad,84.788%,36.228%)", 171, 14, 126, 255},
		{"hsl(202.153,42.328%,57.768%)", 102, 159, 193, 255},
		{"hsl(4.754rad,99.620%,30.456%,-0.115)", 84, 0, 155, 0},
		{"hsl(0.703turn,-9.041%,64.426%,1.076)", 164, 164, 164, 255},
		{"hsl(-0.020turn,22.850%,95.116%,0.123)", 245, 240, 240, 31},
		{"hsl(403.987grad,42.191%,10.063%)", 36, 16, 15, 255},
		{"hsl(0.104turn,49.789%,74.133%,0.198)", 222, 197, 156, 50},
		{"hsl(0.088turn,32.001%,103.668%)", 255, 255, 255, 255},
		{"hsl(53.662,57.956%,60.528%)", 213, 200, 96, 255},
	}
	for i, d := range data {
		c, err := Parse(d.colorStr)
		if err != nil {
			t.Errorf("Parse error: %s", d.colorStr)
			continue
		}
		r, g, b, a := c.RGBA255()
		rgba := [4]uint8{r, g, b, a}
		out := [4]uint8{d.r, d.g, d.b, d.a}
		if rgba != out {
			t.Errorf("(%d) %s -> %v != %v", i, d.colorStr, out, rgba)
		}
	}
}
