// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{OutputStream, PollableOutputStream, Seekable, ffi};
use glib::{
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GMemoryOutputStream")]
    pub struct MemoryOutputStream(Object<ffi::GMemoryOutputStream, ffi::GMemoryOutputStreamClass>) @extends OutputStream, @implements PollableOutputStream, Seekable;

    match fn {
        type_ => || ffi::g_memory_output_stream_get_type(),
    }
}

impl MemoryOutputStream {
    pub const NONE: Option<&'static MemoryOutputStream> = None;

    #[doc(alias = "g_memory_output_stream_new_resizable")]
    pub fn new_resizable() -> MemoryOutputStream {
        unsafe {
            OutputStream::from_glib_full(ffi::g_memory_output_stream_new_resizable()).unsafe_cast()
        }
    }
}

pub trait MemoryOutputStreamExt: IsA<MemoryOutputStream> + 'static {
    #[doc(alias = "g_memory_output_stream_get_data_size")]
    #[doc(alias = "get_data_size")]
    #[doc(alias = "data-size")]
    fn data_size(&self) -> usize {
        unsafe { ffi::g_memory_output_stream_get_data_size(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "g_memory_output_stream_steal_as_bytes")]
    fn steal_as_bytes(&self) -> glib::Bytes {
        unsafe {
            from_glib_full(ffi::g_memory_output_stream_steal_as_bytes(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "data-size")]
    fn connect_data_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_data_size_trampoline<
            P: IsA<MemoryOutputStream>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GMemoryOutputStream,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(MemoryOutputStream::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::data-size".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_data_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<MemoryOutputStream>> MemoryOutputStreamExt for O {}
