// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT
#![allow(deprecated)]

use crate::ffi;
use glib::{
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstBaseSrc")]
    pub struct BaseSrc(Object<ffi::GstBaseSrc, ffi::GstBaseSrcClass>) @extends gst::Element, gst::Object;

    match fn {
        type_ => || ffi::gst_base_src_get_type(),
    }
}

impl BaseSrc {
    pub const NONE: Option<&'static BaseSrc> = None;
}

unsafe impl Send for BaseSrc {}
unsafe impl Sync for BaseSrc {}

pub trait BaseSrcExt: IsA<BaseSrc> + 'static {
    #[doc(alias = "gst_base_src_get_blocksize")]
    #[doc(alias = "get_blocksize")]
    fn blocksize(&self) -> u32 {
        unsafe { ffi::gst_base_src_get_blocksize(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gst_base_src_get_buffer_pool")]
    #[doc(alias = "get_buffer_pool")]
    fn buffer_pool(&self) -> Option<gst::BufferPool> {
        unsafe {
            from_glib_full(ffi::gst_base_src_get_buffer_pool(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_base_src_get_do_timestamp")]
    #[doc(alias = "get_do_timestamp")]
    #[doc(alias = "do-timestamp")]
    fn does_timestamp(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_base_src_get_do_timestamp(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_base_src_is_async")]
    fn is_async(&self) -> bool {
        unsafe { from_glib(ffi::gst_base_src_is_async(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gst_base_src_is_live")]
    fn is_live(&self) -> bool {
        unsafe { from_glib(ffi::gst_base_src_is_live(self.as_ref().to_glib_none().0)) }
    }

    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_base_src_negotiate")]
    fn negotiate(&self) -> bool {
        unsafe { from_glib(ffi::gst_base_src_negotiate(self.as_ref().to_glib_none().0)) }
    }

    #[cfg_attr(feature = "v1_18", deprecated = "Since 1.18")]
    #[allow(deprecated)]
    #[doc(alias = "gst_base_src_new_seamless_segment")]
    fn new_seamless_segment(&self, start: i64, stop: i64, time: i64) -> bool {
        unsafe {
            from_glib(ffi::gst_base_src_new_seamless_segment(
                self.as_ref().to_glib_none().0,
                start,
                stop,
                time,
            ))
        }
    }

    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_base_src_new_segment")]
    fn new_segment(&self, segment: &gst::Segment) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_base_src_new_segment(
                    self.as_ref().to_glib_none().0,
                    segment.to_glib_none().0
                ),
                "Failed to update segment"
            )
        }
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "gst_base_src_push_segment")]
    fn push_segment(&self, segment: &gst::Segment) -> bool {
        unsafe {
            from_glib(ffi::gst_base_src_push_segment(
                self.as_ref().to_glib_none().0,
                segment.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_base_src_set_async")]
    fn set_async(&self, async_: bool) {
        unsafe {
            ffi::gst_base_src_set_async(self.as_ref().to_glib_none().0, async_.into_glib());
        }
    }

    #[doc(alias = "gst_base_src_set_automatic_eos")]
    #[doc(alias = "automatic-eos")]
    fn set_automatic_eos(&self, automatic_eos: bool) {
        unsafe {
            ffi::gst_base_src_set_automatic_eos(
                self.as_ref().to_glib_none().0,
                automatic_eos.into_glib(),
            );
        }
    }

    #[doc(alias = "gst_base_src_set_blocksize")]
    #[doc(alias = "blocksize")]
    fn set_blocksize(&self, blocksize: u32) {
        unsafe {
            ffi::gst_base_src_set_blocksize(self.as_ref().to_glib_none().0, blocksize);
        }
    }

    #[doc(alias = "gst_base_src_set_caps")]
    fn set_caps(&self, caps: &gst::Caps) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_base_src_set_caps(self.as_ref().to_glib_none().0, caps.to_glib_none().0),
                "Failed to set caps"
            )
        }
    }

    #[doc(alias = "gst_base_src_set_do_timestamp")]
    #[doc(alias = "do-timestamp")]
    fn set_do_timestamp(&self, timestamp: bool) {
        unsafe {
            ffi::gst_base_src_set_do_timestamp(
                self.as_ref().to_glib_none().0,
                timestamp.into_glib(),
            );
        }
    }

    #[doc(alias = "gst_base_src_set_dynamic_size")]
    fn set_dynamic_size(&self, dynamic: bool) {
        unsafe {
            ffi::gst_base_src_set_dynamic_size(self.as_ref().to_glib_none().0, dynamic.into_glib());
        }
    }

    #[doc(alias = "gst_base_src_set_format")]
    fn set_format(&self, format: gst::Format) {
        unsafe {
            ffi::gst_base_src_set_format(self.as_ref().to_glib_none().0, format.into_glib());
        }
    }

    #[doc(alias = "gst_base_src_set_live")]
    fn set_live(&self, live: bool) {
        unsafe {
            ffi::gst_base_src_set_live(self.as_ref().to_glib_none().0, live.into_glib());
        }
    }

    #[doc(alias = "gst_base_src_start_complete")]
    fn start_complete(&self, ret: impl Into<gst::FlowReturn>) {
        unsafe {
            ffi::gst_base_src_start_complete(
                self.as_ref().to_glib_none().0,
                ret.into().into_glib(),
            );
        }
    }

    #[doc(alias = "gst_base_src_start_wait")]
    fn start_wait(&self) -> Result<gst::FlowSuccess, gst::FlowError> {
        unsafe { try_from_glib(ffi::gst_base_src_start_wait(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gst_base_src_wait_playing")]
    fn wait_playing(&self) -> Result<gst::FlowSuccess, gst::FlowError> {
        unsafe {
            try_from_glib(ffi::gst_base_src_wait_playing(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "automatic-eos")]
    fn is_automatic_eos(&self) -> bool {
        ObjectExt::property(self.as_ref(), "automatic-eos")
    }

    #[doc(alias = "num-buffers")]
    fn num_buffers(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "num-buffers")
    }

    #[doc(alias = "num-buffers")]
    fn set_num_buffers(&self, num_buffers: i32) {
        ObjectExt::set_property(self.as_ref(), "num-buffers", num_buffers)
    }

    fn is_typefind(&self) -> bool {
        ObjectExt::property(self.as_ref(), "typefind")
    }

    fn set_typefind(&self, typefind: bool) {
        ObjectExt::set_property(self.as_ref(), "typefind", typefind)
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "automatic-eos")]
    fn connect_automatic_eos_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_automatic_eos_trampoline<
            P: IsA<BaseSrc>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstBaseSrc,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(BaseSrc::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::automatic-eos".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_automatic_eos_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "blocksize")]
    fn connect_blocksize_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_blocksize_trampoline<
            P: IsA<BaseSrc>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstBaseSrc,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(BaseSrc::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::blocksize".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_blocksize_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "do-timestamp")]
    fn connect_do_timestamp_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_do_timestamp_trampoline<
            P: IsA<BaseSrc>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstBaseSrc,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(BaseSrc::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::do-timestamp".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_do_timestamp_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "num-buffers")]
    fn connect_num_buffers_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_num_buffers_trampoline<
            P: IsA<BaseSrc>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstBaseSrc,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(BaseSrc::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::num-buffers".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_num_buffers_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "typefind")]
    fn connect_typefind_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_typefind_trampoline<
            P: IsA<BaseSrc>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstBaseSrc,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(BaseSrc::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::typefind".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_typefind_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<BaseSrc>> BaseSrcExt for O {}
