// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{
    Buffer, BufferList, Caps, Element, Event, FlowError, FlowSuccess, Object, PadDirection,
    PadLinkCheck, PadLinkError, PadLinkSuccess, PadMode, PadTemplate, Stream, TaskState, ffi,
};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstPad")]
    pub struct Pad(Object<ffi::GstPad, ffi::GstPadClass>) @extends Object;

    match fn {
        type_ => || ffi::gst_pad_get_type(),
    }
}

impl Pad {
    pub const NONE: Option<&'static Pad> = None;
}

unsafe impl Send for Pad {}
unsafe impl Sync for Pad {}

pub trait PadExt: IsA<Pad> + 'static {
    #[doc(alias = "gst_pad_activate_mode")]
    fn activate_mode(&self, mode: PadMode, active: bool) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_pad_activate_mode(
                    self.as_ref().to_glib_none().0,
                    mode.into_glib(),
                    active.into_glib()
                ),
                "Failed to activate mode pad"
            )
        }
    }

    #[doc(alias = "gst_pad_can_link")]
    fn can_link(&self, sinkpad: &impl IsA<Pad>) -> bool {
        unsafe {
            from_glib(ffi::gst_pad_can_link(
                self.as_ref().to_glib_none().0,
                sinkpad.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_chain")]
    fn chain(&self, buffer: Buffer) -> Result<FlowSuccess, FlowError> {
        unsafe {
            try_from_glib(ffi::gst_pad_chain(
                self.as_ref().to_glib_none().0,
                buffer.into_glib_ptr(),
            ))
        }
    }

    #[doc(alias = "gst_pad_chain_list")]
    fn chain_list(&self, list: BufferList) -> Result<FlowSuccess, FlowError> {
        unsafe {
            try_from_glib(ffi::gst_pad_chain_list(
                self.as_ref().to_glib_none().0,
                list.into_glib_ptr(),
            ))
        }
    }

    #[doc(alias = "gst_pad_check_reconfigure")]
    fn check_reconfigure(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_pad_check_reconfigure(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_create_stream_id")]
    fn create_stream_id(
        &self,
        parent: &impl IsA<Element>,
        stream_id: Option<&str>,
    ) -> glib::GString {
        unsafe {
            from_glib_full(ffi::gst_pad_create_stream_id(
                self.as_ref().to_glib_none().0,
                parent.as_ref().to_glib_none().0,
                stream_id.to_glib_none().0,
            ))
        }
    }

    //#[doc(alias = "gst_pad_create_stream_id_printf")]
    //fn create_stream_id_printf(&self, parent: &impl IsA<Element>, stream_id: Option<&str>, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs) -> glib::GString {
    //    unsafe { TODO: call ffi:gst_pad_create_stream_id_printf() }
    //}

    //#[doc(alias = "gst_pad_create_stream_id_printf_valist")]
    //fn create_stream_id_printf_valist(&self, parent: &impl IsA<Element>, stream_id: Option<&str>, var_args: /*Unknown conversion*//*Unimplemented*/Unsupported) -> glib::GString {
    //    unsafe { TODO: call ffi:gst_pad_create_stream_id_printf_valist() }
    //}

    #[doc(alias = "gst_pad_forward")]
    fn forward<P: FnMut(&Pad) -> bool>(&self, forward: P) -> bool {
        let mut forward_data: P = forward;
        unsafe extern "C" fn forward_func<P: FnMut(&Pad) -> bool>(
            pad: *mut ffi::GstPad,
            user_data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            unsafe {
                let pad = from_glib_borrow(pad);
                let callback = user_data as *mut P;
                (*callback)(&pad).into_glib()
            }
        }
        let forward = Some(forward_func::<P> as _);
        let super_callback0: &mut P = &mut forward_data;
        unsafe {
            from_glib(ffi::gst_pad_forward(
                self.as_ref().to_glib_none().0,
                forward,
                super_callback0 as *mut _ as *mut _,
            ))
        }
    }

    #[doc(alias = "gst_pad_get_allowed_caps")]
    #[doc(alias = "get_allowed_caps")]
    fn allowed_caps(&self) -> Option<Caps> {
        unsafe {
            from_glib_full(ffi::gst_pad_get_allowed_caps(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_get_current_caps")]
    #[doc(alias = "get_current_caps")]
    fn current_caps(&self) -> Option<Caps> {
        unsafe {
            from_glib_full(ffi::gst_pad_get_current_caps(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_get_direction")]
    #[doc(alias = "get_direction")]
    fn direction(&self) -> PadDirection {
        unsafe { from_glib(ffi::gst_pad_get_direction(self.as_ref().to_glib_none().0)) }
    }

    //#[doc(alias = "gst_pad_get_element_private")]
    //#[doc(alias = "get_element_private")]
    //fn element_private(&self) -> /*Unimplemented*/Option<Basic: Pointer> {
    //    unsafe { TODO: call ffi:gst_pad_get_element_private() }
    //}

    #[doc(alias = "gst_pad_get_last_flow_return")]
    #[doc(alias = "get_last_flow_return")]
    fn last_flow_result(&self) -> Result<FlowSuccess, FlowError> {
        unsafe {
            try_from_glib(ffi::gst_pad_get_last_flow_return(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_get_offset")]
    #[doc(alias = "get_offset")]
    fn offset(&self) -> i64 {
        unsafe { ffi::gst_pad_get_offset(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gst_pad_get_pad_template")]
    #[doc(alias = "get_pad_template")]
    fn pad_template(&self) -> Option<PadTemplate> {
        unsafe {
            from_glib_full(ffi::gst_pad_get_pad_template(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_get_pad_template_caps")]
    #[doc(alias = "get_pad_template_caps")]
    fn pad_template_caps(&self) -> Caps {
        unsafe {
            from_glib_full(ffi::gst_pad_get_pad_template_caps(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_get_parent_element")]
    #[doc(alias = "get_parent_element")]
    fn parent_element(&self) -> Option<Element> {
        unsafe {
            from_glib_full(ffi::gst_pad_get_parent_element(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_get_peer")]
    #[doc(alias = "get_peer")]
    #[must_use]
    fn peer(&self) -> Option<Pad> {
        unsafe { from_glib_full(ffi::gst_pad_get_peer(self.as_ref().to_glib_none().0)) }
    }

    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_pad_get_single_internal_link")]
    #[doc(alias = "get_single_internal_link")]
    #[must_use]
    fn single_internal_link(&self) -> Option<Pad> {
        unsafe {
            from_glib_full(ffi::gst_pad_get_single_internal_link(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_get_stream")]
    #[doc(alias = "get_stream")]
    fn stream(&self) -> Option<Stream> {
        unsafe { from_glib_full(ffi::gst_pad_get_stream(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gst_pad_get_stream_id")]
    #[doc(alias = "get_stream_id")]
    fn stream_id(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::gst_pad_get_stream_id(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gst_pad_get_task_state")]
    #[doc(alias = "get_task_state")]
    fn task_state(&self) -> TaskState {
        unsafe { from_glib(ffi::gst_pad_get_task_state(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gst_pad_has_current_caps")]
    fn has_current_caps(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_pad_has_current_caps(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_is_active")]
    fn is_active(&self) -> bool {
        unsafe { from_glib(ffi::gst_pad_is_active(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gst_pad_is_blocked")]
    fn is_blocked(&self) -> bool {
        unsafe { from_glib(ffi::gst_pad_is_blocked(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gst_pad_is_blocking")]
    fn is_blocking(&self) -> bool {
        unsafe { from_glib(ffi::gst_pad_is_blocking(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gst_pad_is_linked")]
    fn is_linked(&self) -> bool {
        unsafe { from_glib(ffi::gst_pad_is_linked(self.as_ref().to_glib_none().0)) }
    }

    //#[doc(alias = "gst_pad_iterate_internal_links")]
    //fn iterate_internal_links(&self) -> /*Ignored*/Option<Iterator> {
    //    unsafe { TODO: call ffi:gst_pad_iterate_internal_links() }
    //}

    //#[doc(alias = "gst_pad_iterate_internal_links_default")]
    //fn iterate_internal_links_default(&self, parent: Option<&impl IsA<Object>>) -> /*Ignored*/Option<Iterator> {
    //    unsafe { TODO: call ffi:gst_pad_iterate_internal_links_default() }
    //}

    #[doc(alias = "gst_pad_link")]
    fn link(&self, sinkpad: &impl IsA<Pad>) -> Result<PadLinkSuccess, PadLinkError> {
        unsafe {
            try_from_glib(ffi::gst_pad_link(
                self.as_ref().to_glib_none().0,
                sinkpad.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_link_full")]
    fn link_full(
        &self,
        sinkpad: &impl IsA<Pad>,
        flags: PadLinkCheck,
    ) -> Result<PadLinkSuccess, PadLinkError> {
        unsafe {
            try_from_glib(ffi::gst_pad_link_full(
                self.as_ref().to_glib_none().0,
                sinkpad.as_ref().to_glib_none().0,
                flags.into_glib(),
            ))
        }
    }

    #[doc(alias = "gst_pad_link_maybe_ghosting")]
    fn link_maybe_ghosting(&self, sink: &impl IsA<Pad>) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_pad_link_maybe_ghosting(
                    self.as_ref().to_glib_none().0,
                    sink.as_ref().to_glib_none().0
                ),
                "Failed to link pads, possibly ghosting"
            )
        }
    }

    #[doc(alias = "gst_pad_link_maybe_ghosting_full")]
    fn link_maybe_ghosting_full(
        &self,
        sink: &impl IsA<Pad>,
        flags: PadLinkCheck,
    ) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_pad_link_maybe_ghosting_full(
                    self.as_ref().to_glib_none().0,
                    sink.as_ref().to_glib_none().0,
                    flags.into_glib()
                ),
                "Failed to link pads, possibly ghosting"
            )
        }
    }

    #[doc(alias = "gst_pad_mark_reconfigure")]
    fn mark_reconfigure(&self) {
        unsafe {
            ffi::gst_pad_mark_reconfigure(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gst_pad_needs_reconfigure")]
    fn needs_reconfigure(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_pad_needs_reconfigure(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_pause_task")]
    fn pause_task(&self) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_pad_pause_task(self.as_ref().to_glib_none().0),
                "Failed to pause pad task"
            )
        }
    }

    #[doc(alias = "gst_pad_peer_query_accept_caps")]
    fn peer_query_accept_caps(&self, caps: &Caps) -> bool {
        unsafe {
            from_glib(ffi::gst_pad_peer_query_accept_caps(
                self.as_ref().to_glib_none().0,
                caps.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_peer_query_caps")]
    fn peer_query_caps(&self, filter: Option<&Caps>) -> Caps {
        unsafe {
            from_glib_full(ffi::gst_pad_peer_query_caps(
                self.as_ref().to_glib_none().0,
                filter.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_push")]
    fn push(&self, buffer: Buffer) -> Result<FlowSuccess, FlowError> {
        unsafe {
            try_from_glib(ffi::gst_pad_push(
                self.as_ref().to_glib_none().0,
                buffer.into_glib_ptr(),
            ))
        }
    }

    #[doc(alias = "gst_pad_push_list")]
    fn push_list(&self, list: BufferList) -> Result<FlowSuccess, FlowError> {
        unsafe {
            try_from_glib(ffi::gst_pad_push_list(
                self.as_ref().to_glib_none().0,
                list.into_glib_ptr(),
            ))
        }
    }

    #[doc(alias = "gst_pad_query_accept_caps")]
    fn query_accept_caps(&self, caps: &Caps) -> bool {
        unsafe {
            from_glib(ffi::gst_pad_query_accept_caps(
                self.as_ref().to_glib_none().0,
                caps.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_query_caps")]
    fn query_caps(&self, filter: Option<&Caps>) -> Caps {
        unsafe {
            from_glib_full(ffi::gst_pad_query_caps(
                self.as_ref().to_glib_none().0,
                filter.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_set_active")]
    fn set_active(&self, active: bool) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_pad_set_active(self.as_ref().to_glib_none().0, active.into_glib()),
                "Failed to activate pad"
            )
        }
    }

    //#[doc(alias = "gst_pad_set_element_private")]
    //fn set_element_private(&self, priv_: /*Unimplemented*/Option<Basic: Pointer>) {
    //    unsafe { TODO: call ffi:gst_pad_set_element_private() }
    //}

    #[doc(alias = "gst_pad_set_offset")]
    #[doc(alias = "offset")]
    fn set_offset(&self, offset: i64) {
        unsafe {
            ffi::gst_pad_set_offset(self.as_ref().to_glib_none().0, offset);
        }
    }

    #[doc(alias = "gst_pad_stop_task")]
    fn stop_task(&self) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_pad_stop_task(self.as_ref().to_glib_none().0),
                "Failed to stop pad task"
            )
        }
    }

    #[doc(alias = "gst_pad_store_sticky_event")]
    fn store_sticky_event(&self, event: &Event) -> Result<FlowSuccess, FlowError> {
        unsafe {
            try_from_glib(ffi::gst_pad_store_sticky_event(
                self.as_ref().to_glib_none().0,
                event.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_pad_unlink")]
    fn unlink(&self, sinkpad: &impl IsA<Pad>) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_pad_unlink(
                    self.as_ref().to_glib_none().0,
                    sinkpad.as_ref().to_glib_none().0
                ),
                "Failed to unlink pad"
            )
        }
    }

    #[doc(alias = "gst_pad_use_fixed_caps")]
    fn use_fixed_caps(&self) {
        unsafe {
            ffi::gst_pad_use_fixed_caps(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "linked")]
    fn connect_linked<F: Fn(&Self, &Pad) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn linked_trampoline<
            P: IsA<Pad>,
            F: Fn(&P, &Pad) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstPad,
            peer: *mut ffi::GstPad,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Pad::from_glib_borrow(this).unsafe_cast_ref(),
                    &from_glib_borrow(peer),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"linked".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    linked_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "unlinked")]
    fn connect_unlinked<F: Fn(&Self, &Pad) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn unlinked_trampoline<
            P: IsA<Pad>,
            F: Fn(&P, &Pad) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstPad,
            peer: *mut ffi::GstPad,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Pad::from_glib_borrow(this).unsafe_cast_ref(),
                    &from_glib_borrow(peer),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"unlinked".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    unlinked_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "caps")]
    fn connect_caps_notify<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_caps_trampoline<
            P: IsA<Pad>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstPad,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Pad::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::caps".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_caps_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "offset")]
    fn connect_offset_notify<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_offset_trampoline<
            P: IsA<Pad>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstPad,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Pad::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::offset".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_offset_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Pad>> PadExt for O {}
