# GStreamer Thumbnailers

This project provides two binaries that create a thumbnails for the `libgnome-desktop` thumbnailer:

- `gst-video-thumbnailer` tries to extract the stored cover art from a video file. If no cover art is found, it checks a few different frames and takes the frame with the largest variance between it's the pixels.
- `gst-audio-thumbnailer` tries to extract the stored cover art from an audio file.

```sh
$ cargo run --bin gst-video-thumbnailer -- -p video.mp4 -o thumbnail.png -s 512
$ cargo run --bin gst-audio-thumbnailer -- -p audio.mp3 -o thumbnail.png -s 512
```

## Dependencies

As the thumbnailers are using GStreamer for parsing and decoding the files, it is necessary to install the required GStreamer plugins with the codecs required for handling the files.
In addition, at least all plugins from GStreamer core and gst-plugins-base are required, as well as the `autodetect` and `videofilter` plugins from gst-plugins-good.

## Benchmarking

To assess the performance impact of a code change:

1. Checkout the `main` branch
2. Call `cargo bench`
3. Checkout your changes
4. Run `cargo bench` again

This will give a report of the performance changes. If there are significant changes in either direction, these should be mentioned in merge requests.

## Use of Generative AI

This project does not allow contributions generated by large languages models (LLMs) and chatbots. This ban includes, but is not limited to, tools like ChatGPT, Claude, Copilot, DeepSeek, and Devin AI. We are taking these steps as precaution due to the potential negative influence of AI generated content on quality, as well as likely copyright violations.

This ban of AI generated content applies to all parts of the projects, including, but not limited to, code, documentation, issues, and artworks. An exception applies for purely translating texts for issues and comments to English.

AI tools can be used to answer questions and find information. However, we encourage contributors to avoid them in favor of using [existing documentation](https://developer.gnome.org) and our [chats and forums](https://welcome.gnome.org). Since AI generated information is frequently misleading or false, we cannot supply support on anything referencing AI output.
