/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package org.openjdk.asmtools.lib.action;

import org.openjdk.asmtools.jdis.Main;
import org.openjdk.asmtools.lib.log.LogAndBinResults;
import org.openjdk.asmtools.lib.log.LogAndTextResults;

import java.nio.file.Path;

import static org.openjdk.asmtools.lib.action.EAsmTool.JDIS;

public final class Jdis extends DecodeActor<Main, LogAndTextResults> {
    public Jdis() {
        super(JDIS);
        inputsDecoder = (encodedFiles, encodeLog, inputs) ->
                new Main(encodedFiles, encodeLog, inputs);
        filesDecoder = (encodedFiles, encodeLog, args) ->
                new Main(encodedFiles, encodeLog, args);
    }

    public Jdis(Path destDir) {
        super(JDIS, destDir);
        inputsDecoder = (encodedFiles, encodeLog, inputs) ->
                new Main(encodedFiles, encodeLog, inputs);
        filesDecoder = (encodedFiles, encodeLog, args) ->
                new Main(encodedFiles, encodeLog, args);
    }

    public Jdis setArgs(EToolArguments args) {
        super.setArgs(args);
        return this;
    }

}
