/*
  SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/
#pragma once
#include "ollamamodelavailableinfo.h"
#include "textautogenerateollama_private_export.h"
#include <QWidget>
#include <TextAutoGenerateText/TextAutoGenerateManager>
namespace TextAutoGenerateText
{
class TextAutoGenerateModelSearchLineEdit;
}
class OllamaModelsInfosCategoriesComboBox;
class QToolButton;
class TEXTAUTOGENERATEOLLAMA_TESTS_EXPORT OllamaModelAvailableSearchWidget : public QWidget
{
    Q_OBJECT
public:
    explicit OllamaModelAvailableSearchWidget(QWidget *parent = nullptr);
    ~OllamaModelAvailableSearchWidget() override;

Q_SIGNALS:
    void searchText(const QString &str);
    void categoriesChanged(const QList<TextAutoGenerateText::TextAutoGenerateManager::Category> &categories);
    void addModel();

private:
    TextAutoGenerateText::TextAutoGenerateModelSearchLineEdit *const mSearchLineEdit;
    OllamaModelsInfosCategoriesComboBox *const mCategoriesComboBox;
    QToolButton *const mAddModelButton;
};
