% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{MultipleFeatures}
\alias{MultipleFeatures}
\title{Multiple features data}
\format{
A data frame with 2000 rows and 382 columns:
\itemize{
\item \code{digit}. The digits to which the feature sets \verb{fou.*}, \verb{kar.*} and \verb{pix.*} correspond to.
\item \verb{fou.*}. 76 Fourier coefficients of the character shapes, which are computed to be rotation invariant.
\item \verb{kar.*}. 64 Karhunen-Lo\`eve coefficients of the character shapes.
\item \verb{pix.*}. 240 pixel averages in 2 x 3 windows of each character shape.
\item \code{training}. \code{TRUE} if the digit is part of the training set
and \code{FALSE} if the digit is allocated to the test set.
}
}
\source{
The data provides the \code{fou}, \code{kar} and \code{pix} features of the
Multiple Features data set from the UCI Machine Learning Repository
(Duin, 1998).
}
\usage{
MultipleFeatures
}
\description{
Digits (0-9) extracted from a collection of maps from a Dutch
public utility.  Two hundred \verb{30 × 48} binary images per digit are
available, which have then been used to extract feature sets; see
Jain et al. (2000), for details, where that dataset is used for
assessing the performance of various classifiers for digit
recognition.
}
\examples{

\donttest{
data("MultipleFeatures", package = "brglm2")

par(mfrow = c(10, 20), mar = numeric(4) + 0.1)
for (c_digit in 0:9) {
   df <- subset(MultipleFeatures, digit == c_digit)
   df <- as.matrix(df[, paste("pix", 1:240, sep = ".")])
   for (inst in 1:20) {
       m <- matrix(df[inst, ], 15, 16)[, 16:1]
       image(m, col = grey.colors(7, 1, 0), xaxt = "n", yaxt = "n")
  }
}

}
}
\references{
Duin, R. (1998). Multiple Features Dataset. UCI Machine Learning
Repository. \doi{10.24432/C5HC70}.

Jain A, Duin R, Mao J (2000). Statistical pattern recognition: a
review. IEEE Transactions on Pattern Analysis and Machine
Intelligence, \strong{22}, 4–37. \doi{10.1109/34.824819}.
}
\seealso{
\code{\link[=mdypl_fit]{mdypl_fit()}}
}
\keyword{datasets}
