% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDouble.R
\name{checkDouble}
\alias{checkDouble}
\alias{check_double}
\alias{assertDouble}
\alias{assert_double}
\alias{testDouble}
\alias{test_double}
\alias{expect_double}
\title{Check that an argument is a vector of type double}
\usage{
checkDouble(
  x,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  names = NULL,
  typed.missing = FALSE,
  null.ok = FALSE
)

check_double(
  x,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  names = NULL,
  typed.missing = FALSE,
  null.ok = FALSE
)

assertDouble(
  x,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  names = NULL,
  typed.missing = FALSE,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

assert_double(
  x,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  names = NULL,
  typed.missing = FALSE,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

testDouble(
  x,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  names = NULL,
  typed.missing = FALSE,
  null.ok = FALSE
)

test_double(
  x,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  names = NULL,
  typed.missing = FALSE,
  null.ok = FALSE
)

expect_double(
  x,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  names = NULL,
  typed.missing = FALSE,
  null.ok = FALSE,
  info = NULL,
  label = vname(x)
)
}
\arguments{
\item{x}{[\code{any}]\cr
Object to check.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than or equal to.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than or equal to.}

\item{finite}{[\code{logical(1)}]\cr
Check for only finite values? Default is \code{FALSE}.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with no non-missing values allowed? Default is \code{TRUE}.
Note that empty vectors do not have non-missing values.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{sorted}{[\code{logical(1)}]\cr
Elements must be sorted in ascending order. Missing values are ignored.}

\item{names}{[\code{character(1)}]\cr
Check for names. See \code{\link{checkNamed}} for possible values.
Default is \dQuote{any} which performs no check at all.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{typed.missing}{[\code{logical(1)}]\cr
If set to \code{FALSE} (default), all types of missing values (\code{NA}, \code{NA_integer_},
\code{NA_real_}, \code{NA_character_} or \code{NA_character_}) as well as empty vectors are allowed
while type-checking atomic input.
Set to \code{TRUE} to enable strict type checking.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertDouble}/\code{assert_double} return 
 \code{x} invisibly, whereas
 \code{checkDouble}/\code{check_double} and 
 \code{testDouble}/\code{test_double} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertDouble}/\code{assert_double}
 throws an error message, 
 \code{testDouble}/\code{test_double}
 returns \code{FALSE},
 and \code{checkDouble}/\code{check_double} 
 return a string with the error message.
 The function \code{expect_double} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check that an argument is a vector of type double
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testDouble(1)
testDouble(1L)
testDouble(1, min.len = 1, lower = 0)
}
\seealso{
Other basetypes: 
\code{\link{checkArray}()},
\code{\link{checkAtomic}()},
\code{\link{checkAtomicVector}()},
\code{\link{checkCharacter}()},
\code{\link{checkComplex}()},
\code{\link{checkDataFrame}()},
\code{\link{checkDate}()},
\code{\link{checkEnvironment}()},
\code{\link{checkFactor}()},
\code{\link{checkFormula}()},
\code{\link{checkFunction}()},
\code{\link{checkInteger}()},
\code{\link{checkIntegerish}()},
\code{\link{checkList}()},
\code{\link{checkLogical}()},
\code{\link{checkMatrix}()},
\code{\link{checkNull}()},
\code{\link{checkNumeric}()},
\code{\link{checkPOSIXct}()},
\code{\link{checkRaw}()},
\code{\link{checkVector}()}
}
\concept{basetypes}
