% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{hardhat-extract}
\alias{hardhat-extract}
\alias{extract_workflow}
\alias{extract_recipe}
\alias{extract_spec_parsnip}
\alias{extract_fit_parsnip}
\alias{extract_fit_engine}
\alias{extract_mold}
\alias{extract_preprocessor}
\alias{extract_postprocessor}
\alias{extract_tailor}
\alias{extract_parameter_dials}
\alias{extract_parameter_set_dials}
\alias{extract_fit_time}
\title{Generics for object extraction}
\usage{
extract_workflow(x, ...)

extract_recipe(x, ...)

extract_spec_parsnip(x, ...)

extract_fit_parsnip(x, ...)

extract_fit_engine(x, ...)

extract_mold(x, ...)

extract_preprocessor(x, ...)

extract_postprocessor(x, ...)

extract_tailor(x, ...)

extract_parameter_dials(x, ...)

extract_parameter_set_dials(x, ...)

extract_fit_time(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Extra arguments passed on to methods.}
}
\description{
These generics are used to extract elements from various model
objects. Methods are defined in other packages, such as tune,
workflows, and workflowsets, but the returned object is always the same.
\itemize{
\item \code{extract_fit_engine()} returns the engine specific fit embedded within
a parsnip model fit. For example, when using \code{parsnip::linear_reg()}
with the \code{"lm"} engine, this returns the underlying \code{lm} object.
\item \code{extract_fit_parsnip()} returns a parsnip model fit.
\item \code{extract_mold()} returns the preprocessed "mold" object returned
from \code{\link[=mold]{mold()}}. It contains information about the preprocessing,
including either the prepped recipe, the formula terms object, or
variable selectors.
\item \code{extract_spec_parsnip()} returns a parsnip model specification.
\item \code{extract_preprocessor()} returns the formula, recipe, or variable
expressions used for preprocessing.
\item \code{extract_recipe()} returns a recipe, possibly estimated.
\item \code{extract_postprocessor()} returns the post-processor.
\item \code{extract_tailor()} returns a tailor, possibly fit.
\item \code{extract_workflow()} returns a workflow, possibly fit.
\item \code{extract_parameter_dials()} returns a single dials parameter object.
\item \code{extract_parameter_set_dials()} returns a set of dials parameter objects.
\item \code{extract_fit_time()} returns a tibble with fit times.
}
}
\examples{
# See packages where methods are defined for examples, such as `parsnip` or
# `workflows`.
}
