/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import java.util.Enumeration;
import rene.util.MyVector;
import rene.zirkel.expression.EquationExpressionString;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.NameExpressionString;
import rene.zirkel.objects.ConstructionObject;

public class ExpressionString {
    MyVector v = new MyVector(3);
    ConstructionObject O;

    public ExpressionString(String string, ConstructionObject constructionObject) {
        int n;
        this.O = constructionObject;
        this.v.removeAllElements();
        int n2 = 0;
        while ((n = string.indexOf("%", n2)) >= 0) {
            int n3 = string.indexOf("%", n + 1);
            if (n3 == n + 1) {
                this.v.addElement(string.substring(n2, n));
                this.v.addElement("%");
                n2 = n + 2;
                continue;
            }
            if (n3 >= 0) {
                Object object;
                this.v.addElement(string.substring(n2, n));
                if (string.charAt(n + 1) == '~') {
                    object = string.substring(n + 2, n3);
                    this.v.addElement(new EquationExpressionString(new Expression(string.substring(n + 2, n3), this.O.getConstruction(), this.O)));
                    n2 = n3 + 1;
                    continue;
                }
                if (string.charAt(n + 1) == '=') {
                    object = string.substring(n + 2, n3);
                    this.v.addElement(new NameExpressionString(new Expression(string.substring(n + 2, n3), this.O.getConstruction(), this.O)));
                    n2 = n3 + 1;
                    continue;
                }
                object = new Expression(string.substring(n + 1, n3), this.O.getConstruction(), this.O);
                this.v.addElement(object);
                n2 = n3 + 1;
                continue;
            }
            this.v.addElement(string.substring(n2, n));
            this.v.addElement("%");
            n2 = n + 1;
        }
        if (!string.equals("")) {
            this.v.addElement(string.substring(n2));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (e2 instanceof String) {
                if (((String)e2).equals("%")) {
                    stringBuffer.append("%%");
                    continue;
                }
                stringBuffer.append((String)e2);
                continue;
            }
            if (e2 instanceof Expression) {
                stringBuffer.append("%");
                if (((Expression)e2).isForcePlus()) {
                    stringBuffer.append("+");
                }
                stringBuffer.append(e2.toString());
                stringBuffer.append("%");
                continue;
            }
            if (e2 instanceof EquationExpressionString) {
                stringBuffer.append("%~");
                stringBuffer.append(((EquationExpressionString)e2).toString());
                stringBuffer.append("%");
                continue;
            }
            if (!(e2 instanceof NameExpressionString)) continue;
            stringBuffer.append("%=");
            stringBuffer.append(((NameExpressionString)e2).toString());
            stringBuffer.append("%");
        }
        return stringBuffer.toString();
    }

    public String evaluate() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (e2 instanceof String) {
                if (((String)e2).equals("%")) {
                    stringBuffer.append("%");
                    continue;
                }
                stringBuffer.append((String)e2);
                continue;
            }
            if (e2 instanceof Expression) {
                try {
                    double d2 = ((Expression)e2).getValue();
                    d2 = this.O.round(d2);
                    if (((Expression)e2).isForcePlus() && d2 >= 0.0) {
                        stringBuffer.append("+");
                    }
                    if (d2 == Math.floor(d2 + 0.5)) {
                        stringBuffer.append((int)d2);
                        continue;
                    }
                    stringBuffer.append(this.O.round(d2));
                }
                catch (Exception exception) {
                    stringBuffer.append("???");
                }
                continue;
            }
            if (e2 instanceof EquationExpressionString) {
                stringBuffer.append(((EquationExpressionString)e2).getEquation());
                continue;
            }
            if (!(e2 instanceof NameExpressionString)) continue;
            stringBuffer.append(((NameExpressionString)e2).getName());
        }
        return stringBuffer.toString();
    }

    public void translate() {
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (e2 instanceof Expression) {
                ((Expression)e2).translate();
                continue;
            }
            if (e2 instanceof EquationExpressionString) {
                ((EquationExpressionString)e2).translate();
                continue;
            }
            if (!(e2 instanceof NameExpressionString)) continue;
            ((NameExpressionString)e2).translate();
        }
    }

    public void addDep(ConstructionObject constructionObject) {
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (e2 instanceof Expression) {
                ((Expression)e2).addDep(constructionObject);
                continue;
            }
            if (e2 instanceof EquationExpressionString) {
                ((EquationExpressionString)e2).addDep(constructionObject);
                continue;
            }
            if (!(e2 instanceof NameExpressionString)) continue;
            ((NameExpressionString)e2).addDep(constructionObject);
        }
    }
}

